/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.utils;

import filenet.vw.base.XMLHelper;
import filenet.vw.base.logging.Logger;
import filenet.ws.utils.WSConstants;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Hashtable;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class WSMessageHelper {
    protected static Logger logger = Logger.getLogger("filenet.ws.utils");
    protected static final String m_className = "WSMessageHelper";
    private static final String Encoding = "UTF-8";
    private static String xmlnsTag = "xmlns";

    public static String _get_FILE_DATE() {
        return "$Date:   23 Oct 2006 09:25:48  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.3  $";
    }

    public static String updateMessageNamespaces(String msg, String[] wsdlSchemaNSs) {
        String m_method = "updateMessageNamespaces: " + msg;
        String message = msg;
        boolean bModified = false;
        Document doc = null;
        if (msg != null) {
            doc = WSMessageHelper.xmlToDocument(msg);
        }
        if (doc != null) {
            Hashtable map = new Hashtable();
            NodeList list = doc.getChildNodes();
            if (list != null) {
                for (int i = 0; i < list.getLength(); ++i) {
                    Node node = list.item(i);
                    if (node == null || !(node instanceof Element) || !WSMessageHelper.mapSchemaNS((Element)node, wsdlSchemaNSs, map)) continue;
                    bModified = true;
                }
            }
            try {
                if (bModified) {
                    message = WSMessageHelper.chileElementsToString(doc);
                }
            }
            catch (Exception ex) {
                logger.throwing(m_className, m_method, ex);
                message = msg;
            }
        }
        return message;
    }

    private static String mapSchemaNS(String msgSchemaNS, String[] wsdlSchemaNSs, Hashtable map) {
        String wsdlSchemaNS = null;
        WSConstants wsConstants = WSConstants.getWSConstant(msgSchemaNS);
        if (wsConstants != null) {
            String msgSchemaNSPrefix = wsConstants.P8BPM_NS_PREFIX;
            wsdlSchemaNS = (String)map.get(msgSchemaNS);
            if (wsdlSchemaNS == null) {
                String msgSchemaNamePart = msgSchemaNS.substring(msgSchemaNSPrefix.length());
                wsdlSchemaNS = WSMessageHelper.locateSubString(msgSchemaNamePart, wsdlSchemaNSs);
                if (wsdlSchemaNS != null) {
                    map.put(msgSchemaNS, wsdlSchemaNS);
                } else {
                    if (msgSchemaNamePart.endsWith("schema/basic")) {
                        msgSchemaNamePart = msgSchemaNamePart.replaceAll("schema/basic", "schema/fn/basic");
                    } else if (msgSchemaNamePart.endsWith("schema/fn/basic")) {
                        msgSchemaNamePart = msgSchemaNamePart.replaceAll("schema/fn/basic", "schema/basic");
                    }
                    wsdlSchemaNS = WSMessageHelper.locateSubString(msgSchemaNamePart, wsdlSchemaNSs);
                    if (wsdlSchemaNS != null) {
                        map.put(msgSchemaNS, wsdlSchemaNS);
                    }
                }
            }
        }
        return wsdlSchemaNS;
    }

    private static boolean mapSchemaNS(Element elt, String[] wsdlSchemaNSs, Hashtable map) {
        boolean bModified = false;
        if (map == null) {
            map = new Hashtable();
        }
        if (elt != null) {
            NodeList list;
            String newNS;
            String ns = elt.getAttribute(xmlnsTag);
            if (ns != null && ns.length() > 0 && (newNS = WSMessageHelper.mapSchemaNS(ns, wsdlSchemaNSs, map)) != null && newNS.compareTo(ns) != 0) {
                elt.removeAttribute(xmlnsTag);
                elt.setAttribute(xmlnsTag, newNS);
                bModified = true;
            }
            if ((list = elt.getChildNodes()) != null) {
                for (int i = 0; i < list.getLength(); ++i) {
                    Node node = list.item(i);
                    if (node == null || !(node instanceof Element) || !WSMessageHelper.mapSchemaNS((Element)node, wsdlSchemaNSs, map)) continue;
                    bModified = true;
                }
            }
        }
        return bModified;
    }

    private static String locateSubString(String subString, String[] strings) {
        if (subString != null && subString.length() > 0) {
            for (int i = 0; i < strings.length; ++i) {
                if (strings[i] == null || strings[i].length() <= 0 || strings[i].indexOf(subString) == -1) continue;
                return strings[i];
            }
        }
        return null;
    }

    private static Document xmlToDocument(String xml) {
        if (xml == null) {
            return null;
        }
        String m_method = "xmlToDocument:";
        try {
            String rootElementName = "tempRoot";
            String s = null;
            if (xml.indexOf("<" + rootElementName + ">") == -1) {
                s = "<" + rootElementName + ">" + xml.replaceAll("\n", "") + "</" + rootElementName + ">";
            }
            Document doc = XMLHelper.parseDocumentViaDOM(new InputSource(new StringReader(s)), null, null, false, false);
            Document document = XMLHelper.newDocumentViaDOM();
            Element root = document.createElement(rootElementName);
            document.appendChild(root);
            NodeList list = doc.getChildNodes();
            Node node = null;
            node = doc.getFirstChild();
            if (node.getNodeName().compareTo(rootElementName) == 0) {
                list = node.getChildNodes();
                for (int i = 0; i < list.getLength(); ++i) {
                    if (list.item(i) == null || list.item(i).getNodeType() != 1) continue;
                    Element elt = WSMessageHelper.createElement(document, list.item(i));
                    root.appendChild(elt);
                }
            } else {
                Element elt = WSMessageHelper.createElement(document, node);
                root.appendChild(elt);
            }
            return document;
        }
        catch (Throwable t) {
            logger.throwing(m_className, m_method, t);
            return null;
        }
    }

    private static Element createElement(Document doc, Node node) {
        NodeList list;
        if (node == null || node.getNodeType() != 1) {
            return null;
        }
        Element element = doc.createElement(node.getNodeName());
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null && attributes.getLength() > 0) {
            Node attribute = null;
            for (int j = 0; j < attributes.getLength(); ++j) {
                attribute = attributes.item(j);
                element.setAttribute(attribute.getNodeName(), attribute.getNodeValue());
            }
        }
        if ((list = node.getChildNodes()) != null && list.getLength() > 0) {
            Node nd = null;
            block6: for (int i = 0; i < list.getLength(); ++i) {
                nd = list.item(i);
                short nodeType = nd.getNodeType();
                switch (nodeType) {
                    case 2: 
                    case 8: {
                        continue block6;
                    }
                    case 3: {
                        element.appendChild(doc.createTextNode(nd.getNodeValue()));
                        continue block6;
                    }
                    case 1: {
                        element.appendChild(WSMessageHelper.createElement(doc, nd));
                    }
                }
            }
        }
        return element;
    }

    private static String chileElementsToString(Document doc) throws IOException {
        String method = "elementToString(Document doc)";
        if (doc != null) {
            OutputFormat format = new OutputFormat(doc);
            format.setEncoding(Encoding);
            format.setIndenting(true);
            StringWriter stringOut = new StringWriter();
            XMLSerializer serial = new XMLSerializer((Writer)stringOut, format);
            try {
                serial.asDOMSerializer();
                Node child = doc.getDocumentElement().getFirstChild();
                while (!(child instanceof Element) && (child = child.getNextSibling()) != null) {
                }
                if (child != null && child instanceof Element) {
                    serial.serialize((Element)child);
                    StringBuffer buf = stringOut.getBuffer();
                    buf.delete(0, buf.length() - 1);
                    while (child != null && child instanceof Element) {
                        Element elt = (Element)child;
                        serial.serialize(elt);
                        child = elt.getNextSibling();
                    }
                }
            }
            catch (IOException ex) {
                logger.throwing(m_className, method, ex);
                throw ex;
            }
            String s = stringOut.toString();
            String results = new String();
            int startIndex = 0;
            int endIndex = 0;
            while ((endIndex = s.indexOf("<?xml", startIndex)) != -1) {
                if (endIndex > startIndex) {
                    results = results + s.substring(startIndex, endIndex);
                }
                if ((startIndex = s.indexOf("?>", endIndex)) == -1) continue;
                startIndex += 2;
            }
            results = results + s.substring(startIndex);
            results = results.trim();
            return results;
        }
        return new String();
    }
}

